---
generated_at: 2026-02-04 10:20:00
metrics:
  claims_total: 14
  claims_with_evidence: 14
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：45-フォームレイアウト（Bootstrap 3）

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：14 / 14、根拠なし：0
- 優先レビュー（高）
  - なし（全主張が根拠付き）

## 2) 参照した情報（Evidence一覧）

- E-01: `src/Symfony/Bridge/Twig/Resources/views/Form/bootstrap_3_layout.html.twig` L1-217
- E-02: `src/Symfony/Bridge/Twig/Resources/views/Form/bootstrap_base_layout.html.twig` L1-209
- E-03: `docs/code-to-docs/画面一覧/画面一覧.csv` 行46（No.45のエントリ）
- E-04: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` 行116-117（No.45の関連機能）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | bootstrap_base_layoutをuseタグで読み込む | E-01 L1 | ○ |
| C-02 | form_widget_simpleにform-controlクラスを適用 | E-01 L5-10 | ○ |
| C-03 | button_widgetにbtn-default btnクラスを適用 | E-01 L12-15 | ○ |
| C-04 | money_widgetでinput-group/input-group-addonを使用 | E-01 L17-33 | ○ |
| C-05 | checkbox_widgetでdiv.checkboxラッパーを生成 | E-01 L35-44 | ○ |
| C-06 | radio_widgetでdiv.radioラッパーを生成 | E-01 L46-55 | ○ |
| C-07 | form_labelにcontrol-labelクラスを適用 | E-01 L64-67 | ○ |
| C-08 | form_row_renderでform-group + has-errorクラスを適用 | E-01 L130-137 | ○ |
| C-09 | form_errorsでhelp-block/alert-danger + glyphiconを使用 | E-01 L183-193 | ○ |
| C-10 | form_helpでhelp-blockクラスのspanを生成 | E-01 L197-216 | ○ |
| C-11 | checkbox_radio_labelでwidgetをlabel内に埋め込み | E-01 L87-126 | ○ |
| C-12 | choice_row/date_row/time_row/datetime_rowでforce_error=true | E-01 L145-163 | ○ |
| C-13 | 3層の継承構造（div_layout→base_layout→3_layout） | E-01 L1, E-02 L1 | ○ |
| C-14 | 関連機能：Form、Twig Bridge | E-04 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - テンプレートファイルの全ブロックを確認済み

## 6) レビュアーチェックリスト（最小）
- [ ] Bootstrap 3のCSSクラス名が正確か確認（特にglyphiconアイコン名）
- [ ] has-errorクラスの適用条件が正確か確認
- [ ] checkbox/radio のインライン表示対応が正確か確認
